<?php
session_start();

// Include config.php to get the credentials
include('config.php');

// Redirect to admin page if already logged in
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    header("Location: filthydog1291.php");
    exit();
}

// Initialize error message
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Check if the entered username and password match the valid credentials
    if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
        $_SESSION['logged_in'] = true; // Set session variable to mark user as logged in
        header("Location: filthydog1291.php"); // Redirect to admin page
        exit();
    } else {
        $error = 'Invalid username or password'; // Error message for incorrect login
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <style>
        * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Roboto', sans-serif; }
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f3f4f6;
            transition: background-color 0.3s, color 0.3s;
        }
        .login-container {
            background: #ffffff;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            max-width: 400px;
            width: 100%;
            text-align: center;
            transition: background 0.3s, box-shadow 0.3s;
        }
        .login-container h1 {
            color: #333;
            margin-bottom: 20px;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        .form-group label {
            color: #555;
            font-weight: bold;
            margin-bottom: 5px;
            display: block;
        }
        .form-group input[type="text"], 
        .form-group input[type="password"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        .form-group input[type="text"]:focus, 
        .form-group input[type="password"]:focus {
            border-color: #007bff;
            outline: none;
        }
        .form-group button {
            width: 100%;
            padding: 10px;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .form-group button:hover {
            background-color: #0056b3;
        }
        .error {
            color: red;
            margin-top: 10px;
        }
        /* Dark mode styles */
        body.dark-mode {
            background-color: #181818;
            color: #e0e0e0;
        }
        body.dark-mode .login-container {
            background: #282828;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }
        body.dark-mode .login-container h1 {
            color: #f0f0f0;
        }
        body.dark-mode .form-group label {
            color: #ddd;
        }
        body.dark-mode .form-group input[type="text"], 
        body.dark-mode .form-group input[type="password"] {
            background: #383838;
            border: 1px solid #555;
            color: #e0e0e0;
        }
        body.dark-mode .form-group input[type="text"]:focus, 
        body.dark-mode .form-group input[type="password"]:focus {
            border-color: #007bff;
        }
        body.dark-mode .form-group button {
            background-color: #007bff;
        }
        body.dark-mode .form-group button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h1>Login</h1>
        <form method="POST">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <button type="submit">Login</button>
            </div>
            <?php if ($error): ?>
                <p class="error"><?php echo $error; ?></p>
            <?php endif; ?>
        </form>
        <div class="form-group mt-4">
            <button id="darkModeToggle" class="btn btn-secondary btn-block">Enable Dark Mode</button>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script>
        const toggleButton = document.getElementById('darkModeToggle');
        let darkMode = false;

        toggleButton.addEventListener('click', () => {
            darkMode = !darkMode;
            document.body.classList.toggle('dark-mode', darkMode);
            toggleButton.textContent = darkMode ? 'Disable Dark Mode' : 'Enable Dark Mode';
        });
    </script>
</body>
</html>
